﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography.X509Certificates;
using System.IO;
using CryptoCMP.PKCS7;
using CryptoCMP;

namespace testPKCS7_cmp
{
    class Program
    {
        static void Main(string[] args)
        {

            X509Store store = new X509Store("MY");
            X509Certificate2 cert = null;
            // При выборе сертификата нужно учитывать его политику (на подпись или на ключевой обмен).
            // Для подписывания можно использовать только сертификаты на подпись, иначе будет Exception
            try
            {
                store.Open(OpenFlags.ReadOnly);
                X509Certificate2Collection certCollection = store.Certificates;
                X509Certificate2Collection signingCert = certCollection.Find(X509FindType.FindBySubjectName, "Vogonova001", false);
                cert = signingCert[0];
            }
            finally
            {
                store.Close();
            }
            // формируем сертификаты, которые должны быть вложены в сообщение
            // пока обязательно вкладывать свой сертификат
            FileStream f_cert = new FileStream("c:\\1\\resp2.cer", FileMode.OpenOrCreate);
            byte[] cert_resp = new byte[f_cert.Length];
            f_cert.Read(cert_resp, 0, cert_resp.Length);
            f_cert.Close();
            X509Certificate2 resp_cert2 = new X509Certificate2(cert_resp);
            X509Certificate2[] arr_cert = new X509Certificate2[1];
            arr_cert[0] = resp_cert2;
           // arr_cert[1] = cert;

            CMPPkcs7 pkcs7 = new CMPPkcs7();
            pkcs7.hash_alg = CpTumar.CALG_TGR3411;
            pkcs7.signed_attrs = new System.Collections.Hashtable();
            pkcs7.signed_attrs.Add(System.Text.Encoding.ASCII.GetBytes(AttributesOID.szOID_RSA_emailAddr), System.Text.Encoding.ASCII.GetBytes("e_vogonovs@gamma.kz"));
            pkcs7.unsigned_attrs = new System.Collections.Hashtable();
            pkcs7.unsigned_attrs.Add(System.Text.Encoding.ASCII.GetBytes(AttributesOID.szOID_RSA_unstructName), System.Text.Encoding.ASCII.GetBytes("какой-то табельный номер"));
            byte[] pkcs7_res = pkcs7.FormPKCS7(cert, System.Text.Encoding.ASCII.GetBytes("qwerty"), arr_cert, true); // вариант с хранилищем

            byte[] pkcs7_res_profile = pkcs7.FormPKCS7("profile://OCSP_TEST", System.Text.Encoding.ASCII.GetBytes("qwerty"), arr_cert, false); // вариант с профайлом

            CMPPkcs7 ver = new CMPPkcs7();
            ver.hash_alg = CpTumar.CALG_TGR3411;
            // получаем подписанные атрибуты
            string s_attr = System.Text.Encoding.ASCII.GetString(ver.GetPKCS7SignedAttribute(pkcs7_res, System.Text.Encoding.ASCII.GetBytes("qwerty"), AttributesOID.szOID_RSA_emailAddr));
            // получаем неподписанные атрибуты
            string u_attr = System.Text.Encoding.ASCII.GetString(ver.GetPKCS7UnsignedAttribute(pkcs7_res, System.Text.Encoding.ASCII.GetBytes("qwerty"), AttributesOID.szOID_RSA_unstructName));

            bool r = ver.VerifyPKCS7(pkcs7_res_profile, System.Text.Encoding.ASCII.GetBytes("qwerty")); // если данные не были вложены
            bool r2 = ver.VerifyPKCS7(pkcs7_res, null); // если данные  были вложены
        }
    }
}
